YUI.add("yuidoc-meta", function(Y) {
   Y.YUIDoc = { meta: {
    "classes": [
        "TYRO.BaseIClient",
        "TYRO.IClient",
        "TYRO.IClientEmbedded",
        "TYRO.IClientWithUI"
    ],
    "modules": [
        "TYRO"
    ],
    "allModules": [
        {
            "displayName": "TYRO",
            "name": "TYRO",
            "description": "<h4>Overview</h4>\nThe Tyro iClient provides a javascript client side library to initiate payment transactions with a Tyro terminal. There are two ways to use it.\n<ul>\n<li>Writing your own user interface. {{#crossLink \"TYRO.IClient\"}}{{/crossLink}}</li>\n<li>Using Tyro's user interface. {{#crossLink \"TYRO.IClientWithUI\"}}{{/crossLink}}</li>\n</ul>\nWithin this split you can choose to have receipts printed by the terminal or returned as pre-formatted blocks of text to be printed by a printer\nattached to the POS.\n<a id=\"sequenceDiagrams\"></a>\n<h4>Sequence Diagrams</h4>\nThe following diagrams show the interaction between the POS and iClient in increasing order of control taken by the POS:\n<ol>\n<li><a href=\"purchase-with-tyro-ui-terminal-receipt.png\">IClient with UI - terminal prints receipt</a></li>\n<li><a href=\"purchase-with-tyro-ui-integrated-receipt.png\">IClient with UI - POS prints receipt</a></li>\n<li><a href=\"purchase-terminal-receipt.png\">IClient (POS UI) - terminal prints receipt</a></li>\n<li><a href=\"purchase-integrated-receipt.png\">IClient (POS UI) - POS prints receipt</a></li>\n</ol>\n\n\n <h4>Transaction callbacks</h4>\n The main coding task for a POS using the Tyro iClient is implementing the set of transaction callbacks.\n The full set only applies to a POS taking control over the user interface (using the {{#crossLink \"TYRO.IClient\"}}{{/crossLink}}).\n Each of the initiate purchase, refund and open tab methods involve the following set of callbacks:\n <div class=\"item\">\n <a id=\"questionCallback\"></a>\n <h5>Question Callback ({{#crossLink \"TYRO.IClient\"}}{{/crossLink}} only)</h5>\n Invoked when the terminal requires the merchant to answer a question in order to proceed with the transaction. Called with the following parameters:\n <ul>\n <li class=\"param\"><code class=\"param-name\">question</code><span class=\"type\">Object</span>\n <br/>The question to be presented to the merchant consisting of:\n <ul>\n <li class=\"param\"><code class=\"param-name\">text</code><span class=\"type\">String</span> <br/>The message to present to the merchant.</li>\n <li class=\"param\"><code class=\"param-name\">options</code><span class=\"type\">Array[String]</span> <br/>The set of button labels to present.\n A button should be presented to the merchant for each element in this array.</li>\n </ul>\n </li>\n <li class=\"param\"><code class=\"param-name\">answerCallback</code><span class=\"type\">Function</span>\n <br/>The callback to be used to provide the merchant's answer to the question. The POS should call this function when the merchant clicks one of\n the buttons passing the label of the clicked button (from the options array in the question).\n </li>\n </ul>\n\n <a id=\"statusMessageCallback\"></a>\n <h5>Status Message Callback ({{#crossLink \"TYRO.IClient\"}}{{/crossLink}} only)</h5>\n Invoked to advertise what is happening on terminal, which is typically facing the customer rather than the merchant. Called with a single String argument. For example \"Select account\".\n\n <a id=\"receiptCallback\"></a>\n  <h5>Receipt Callback</h5>\n Invoked when integrated receipts are enabled and a merchant copy of the receipt is available. Ignored if integrated receipt printing is disabled. Called with the following parameters:\n  <ul>\n  <li class=\"param\"><code class=\"param-name\">receipt</code><span class=\"type\">Object</span>\n     <br/>A merchant copy of the receipt consisting of:\n     <ul>\n         <li class=\"param\"><code class=\"param-name\">signatureRequired</code><span class=\"type\">Boolean</span>\n             <br/> Indicates whether a signature line should be printed and a customer signature collected.\n         </li>\n         <li class=\"param\"><code class=\"param-name\">merchantReceipt</code><span class=\"type\">String</span>\n             <br/>Text representation of the Tyro receipt intended for the merchant. Formatted to be printed in a monospaced font.\n         </li>\n     </ul>\n  </li>\n  </ul>\n\n <a id=\"transactionCompleteCallback\"></a>\n<h5>Transaction Complete Callback</h5>\nInvoked when the transaction has been completed on the terminal. Called with a subset of the following parameters:\n<ul>\n    <li class=\"param\"><code class=\"param-name\">transactionData</code><span class=\"type\">Object</span>\n        <br/>An object consisting of:\n        <ul>\n            <li class=\"param\"><code class=\"param-name\">result</code><span class=\"type\">String</span>\n                <br/> One of the following values: APPROVED, CANCELLED, REVERSED, DECLINED, SYSTEM ERROR, NOT STARTED, UNKNOWN.\n                <br/> The merchant will only receive money if this value is APPROVED.\n                <br/> UNKNOWN means the merchant should look at the terminal to determine what happened. Typically this would indicate a network error.\n            </li>\n            <li class=\"param\"><code class=\"param-name\">cardType</code><span class=\"type\">String</span>\n                <br/> The scheme displayed on the card (Visa, Mastercard, etc).\n            </li>\n            <li class=\"param\"><code class=\"param-name\">transactionReference</code><span class=\"type\">String</span>\n                <br/> Also known as a STAN, this is Tyro's reference to this transaction. Quote this to Tyro Customer Support if you run into any issues with a\n                transaction.\n            </li>\n            <li class=\"param\"><code class=\"param-name\">authorisationCode</code><span class=\"type\">String</span>\n                <br/> The Scheme's reference to the transaction. Quote this number to Visa/Mastercard/etc if the issue is on their end.\n            </li>\n            <li class=\"param\"><code class=\"param-name\">issuerActionCode</code><span class=\"type\">String</span>\n                <br/> The raw result code returned by the card issuer.\n            </li>\n            <li class=\"param\"><code class=\"param-name\">elidedPan</code><span class=\"type\">String</span>\n                <br/> The (elided) credit card number used for this transaction.\n            </li>\n            <li class=\"param\"><code class=\"param-name\">rrn</code><span class=\"type\">String</span>\n                <br/> The Retrieval Reference Number is a unique number generated by the Payment Service for a specific merchant. Guaranteed to be unique for a\n                7-day period.\n            </li>\n            <li class=\"param\"><code class=\"param-name\">tipAmount</code><span class=\"type\">String</span>\n                <br/> If you are performing a Tip Completion, the tip component will be returned here, in cents.\n            </li>\n            <li class=\"param\"><code class=\"param-name\">tipCompletionReference</code><span class=\"type\">String</span>\n                <br/> Tyro's reference to the Tip Completion.\n            </li>\n            <li class=\"param\"><code class=\"param-name\">tabCompletionReference</code><span class=\"type\">String</span>\n                <br/> Tyro's reference to a Tab Completion.\n            </li>\n            <li class=\"param\"><code class=\"param-name\">preAuthCompletionReference</code><span class=\"type\">String</span>\n                <br/> Tyro's reference to a PreAuth Completion.\n            </li>\n            <li class=\"param\"><code class=\"param-name\">cardToken</code><span class=\"type\">String</span>\n                <br/> If you are requesting a Card Token, the Card Token will be returned here, in 30 case insensitive alphanumeric characters.\n            </li>\n            <li class=\"param\"><code class=\"param-name\">cardTokenExpiryDate</code><span class=\"type\">String</span>\n                <br/> If you are requesting a Card Token, the expiry of the Card Token will be returned here, in yyyy-MM-dd format.\n            </li>\n            <li class=\"param\"><code class=\"param-name\">cardTokenStatusCode</code><span class=\"type\">String</span>\n                <br/> If you are requesting a Card Token, the status code of the Card Token request will be returned here, 00 indicates success.\n            </li>\n            <li class=\"param\"><code class=\"param-name\">cardTokenErrorMessage</code><span class=\"type\">String</span>\n                <br/> If you are requesting a Card Token and Tyro fails to generate one for you, the reason for the failure will be returned here.\n            </li>\n            <li class=\"param\"><code class=\"param-name\">customerReceipt</code><span class=\"type\">String</span>\n                <br/>Text representation of the Tyro receipt intended for the customer. Only included if integrated receipt printing is enabled. Formatted to be\n                printed in a monospaced font.\n            </li>\n            <h4 style=\"color: #30418C\">For Healthpoint Claims</h4>\n            <li class=\"param\"><code class=\"param-name\">healthpointRefTag</code><span class=\"type\">String</span>\n                <br/>The reference tag generated by the terminal that identifies a transaction per terminal\n            </li>\n            <li class=\"param\"><code class=\"param-name\">healthpointTotalBenefitAmount</code><span class=\"type\">String</span>\n                <br/>Total benefit amount for all claim items\n            </li>\n            <li class=\"param\"><code class=\"param-name\">healthpointSettlementDateTime</code><span class=\"type\">String</span>\n                <br/>Settlement date time as decided by the iCS system/health fund\n            </li>\n            <li class=\"param\"><code class=\"param-name\">healthpointTerminalDateTime</code><span class=\"type\">String</span>\n                <br/>The transaction date time of the claim/s\n            </li>\n            <li class=\"param\"><code class=\"param-name\">healthpointMemberNumber</code><span class=\"type\">String</span>\n                <br/>Private health fund member number of cardholder\n            </li>\n            <li class=\"param\"><code class=\"param-name\">healthpointProviderId\"</code><span class=\"type\">String</span>\n                <br/>Provider ID matching the original request\n            </li>\n            <li class=\"param\"><code class=\"param-name\">healthpointServiceType</code><span class=\"type\">String</span>\n                <br/>Service type matching the original request\n            </li>\n            <li class=\"param\"><code class=\"param-name\">healthpointGapAmount</code><span class=\"type\">String</span>\n                <br/>The gap amount. Will only be present on successful claims and voids.\n            </li>\n            <li class=\"param\"><code class=\"param-name\">healthpointPhfResponseCode</code><span class=\"type\">String</span>\n                <br/>The response code from the private health fund.\n            </li>\n            <li class=\"param\"><code class=\"param-name\">healthpointPhfResponseCodeDescription</code><span class=\"type\">String</span>\n                <br/>The description of the response code from the private health fund.\n            </li>\n            <li class=\"param\"><code class=\"param-name\">healthpointHealthFundName</code><span class=\"type\">String</span>\n                <br/>The name of the private health fund.\n            </li>\n            <li class=\"param\"><code class=\"param-name\">healthpointHealthFundIdentifyingDigits</code><span class=\"type\">String</span>\n                <br/>The identifying digits of the private health fund.\n            </li>\n            <li class=\"param\"><code class=\"param-name\">healthpointClaimItems</code><span class=\"type\">Object</span>\n                <ul>\n                    <li class=\"param\"><code class=\"param-name\">claimAmount</code><span class=\"type\">String</span>\n                        <br/>Claim Item amount in cents (max. 10 digits)\n                    </li>\n                    <li class=\"param\"><code class=\"param-name\">rebateAmount</code><span class=\"type\">String</span>\n                        <br/>Rebate amount for the claim made (max. 10 digits)\n                    </li>\n                    <li class=\"param\"><code class=\"param-name\">serviceCode</code><span class=\"type\">String</span>\n                        <br/>Item Service Code\n                    </li>\n                    <li class=\"param\"><code class=\"param-name\">description</code><span class=\"type\">String</span>\n                        <br/>Item description (max. 32 characters)\n                    </li>\n                    <li class=\"param\"><code class=\"param-name\">serviceReference</code><span class=\"type\">String</span>\n                        <br/>Item Service Ref (max. 3 characters)\n                    </li>\n                    <li class=\"param\"><code class=\"param-name\">patientId</code><span class=\"type\">String</span>\n                        <br/>Patient id as on card (2 digits)\n                    </li>\n                    <li class=\"param\"><code class=\"param-name\">serviceDate</code><span class=\"type\">String</span>\n                        <br/>Date of claim in format \"yyyyMMddhhmmss\"\n                    </li>\n                    <li class=\"param\"><code class=\"param-name\">responseCode</code><span class=\"type\">String</span>\n                        <br/>Individual response code for this item\n                    </li>\n                </ul>\n        </ul>\n    </li>\n</ul>\n</div>"
        }
    ]
} };
});